﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

namespace hiveAdiz
{
    public class AdEventHandlers
    {
        private AdEventHandlers() { }
        // Common
        public Action onAdLoad { get; private set; } = null;
        public Action onAdShow { get; private set; } = null;
        public Action onAdClose { get; private set; } = null;
        public Action<AdizError> onAdFail { get; private set; } = null;
        public Action<RewardItem> onAdReward { get; private set; } = null;
        public Action<AdRevenueData> onAdPaidEvent { get; private set; } = null;
        public Action onAdClick { get; private set; } = null;

        public class Builder
        {
            private AdEventHandlers eventHandlers;

            public Builder()
            {
                this.eventHandlers = new AdEventHandlers();
            }

            public Builder OnAdLoad(Action args) { eventHandlers.onAdLoad = args; return this; }
            public Builder OnAdFail(Action<AdizError> args) { eventHandlers.onAdFail = args; return this; }
            public Builder OnAdShow(Action args) { eventHandlers.onAdShow = args; return this; }
            public Builder OnAdReward(Action<RewardItem> args) { eventHandlers.onAdReward = args; return this; }
            public Builder OnAdClose(Action args) { eventHandlers.onAdClose = args; return this; }
            public Builder OnAdClick(Action args) { eventHandlers.onAdClick = args; return this; }
            public Builder OnAdPaidEvent(Action<AdRevenueData> args) { eventHandlers.onAdPaidEvent = args; return this; }
            public AdEventHandlers Build() { return this.eventHandlers; }
        }

    }

}